<?
// cookiecutter.php
// Chapter 6 - Foundation PHP for Flash

// Determine what action to take
switch ($action) {
    
    // If we're fetching the cookies...
    case 'getcookies': {
        
        // Initialise variable to hold cookie list
        $cookieList = "";

        // Loop through all the cookies, adding them to the cookie list variable
        foreach($HTTP_COOKIE_VARS as $cookieName => $cookieValue) {
            $cookieList .= "$cookieName: $cookieValue\n";
        }

        // Fetch total number of cookies
        $cookieCount = count($HTTP_COOKIE_VARS);

        // Output cookie information back to Flash
        echo "&cookieCount=$cookieCount";
        echo "&cookieList=" . urlencode($cookieList);
        
        // Done
        break;
    }
    
    // If we're setting a cookie..
    case 'setcookie': {
        
        // If specified duration is zero...
        if ($cookieDuration == 0) {
            
            // Set cookie for this browser session only
            setcookie($cookieName, $cookieValue);
        } else {
            
            // Otherwise convert the duration days into a future date.
            $expiryDate = time() + ($cookieDuration * 86400);
            
            // Set the cookie with the calculated expiry date
            setcookie($cookieName, $cookieValue, $expiryDate);
        }
        
        // Done
        echo '&result=Okay';
        break;
    }
        
    // If we're removing a cookie...
    case 'killcookie': {
        
        // Force cookie to expire
        setcookie($cookieName, '', 0);
        
        // Done
        echo '&result=Okay';
        break;
    }
}
?>